// Login endpoint
router.post('/login', 
  middleware.validateInput({
    correo: { required: true, type: 'email' },
    clave: { required: true, minLength: 1 }
  }),
  async (req, res) => {
    const { correo, clave } = req.body;
    console.log('👤 Intento de login para:', correo);
    
    try {
      // 1. Buscar usuario con información de empresa
      console.log('🔍 Buscando usuario en la base de datos...');
      const users = await helpers.query(`
        SELECT 
          u.id,
          u.nombre,
          u.correo,
          u.clave,
          u.rol,
          u.id_empresa,
          e.nombre as empresa_nombre
        FROM usuarios u
        LEFT JOIN empresas e ON u.id_empresa = e.id
        WHERE u.correo = ? AND u.activo = 1
      `, [correo]);
      
      console.log('📊 Resultados encontrados:', users.length);
      
      if (users.length === 0) {
        return res.status(401).json({
          success: false,
          message: 'Credenciales inválidas'
        });
      }
      
      // 2. Verificar contraseña
      const user = users[0];
      console.log('✅ Usuario encontrado:', {
        id: user.id,
        correo: user.correo,
        rol: user.rol,
        empresa: user.empresa_nombre
      });
      
      let passwordValid = false;
      
      // Primero intentar con bcrypt
      try {
        passwordValid = await bcrypt.compare(clave, user.clave);
        console.log('🔒 Resultado bcrypt:', passwordValid);
      } catch (error) {
        console.error('❌ Error en bcrypt:', error);
      }
      
      // En desarrollo, permitir acceso directo para admin
      if (!passwordValid && 
          process.env.NODE_ENV === 'development' && 
          correo === 'juan.admin@motoexperts.cl' && 
          clave === 'MotoAdmin2025#') {
        console.log('🔑 Usando verificación directa para admin en desarrollo');
        passwordValid = true;
        
        // Actualizar hash para futuros logins
        try {
          const newHash = await bcrypt.hash(clave, 10);
          await helpers.query(
            'UPDATE usuarios SET clave = ? WHERE id = ?',
            [newHash, user.id]
          );
          console.log('✅ Hash actualizado para admin');
        } catch (updateError) {
          console.error('⚠️ Error al actualizar hash:', updateError);
          // Continuar a pesar del error de actualización
        }
      }
      
      if (!passwordValid) {
        return res.status(401).json({
          success: false,
          message: 'Credenciales inválidas'
        });
      }
      
      // 3. Generar token JWT
      console.log('🎟️ Generando token JWT...');
      const token = jwt.sign(
        {
          userId: user.id,
          correo: user.correo,
          rol: user.rol,
          id_empresa: user.id_empresa
        },
        JWT_SECRET,
        { expiresIn: '24h' }
      );
      
      // 4. Preparar respuesta (sin incluir el hash)
      const userData = {
        id: user.id,
        nombre: user.nombre,
        correo: user.correo,
        rol: user.rol,
        id_empresa: user.id_empresa,
        empresa_nombre: user.empresa_nombre
      };
      
      console.log('✅ Login exitoso para:', userData.correo);
      
      res.json({
        success: true,
        message: 'Login exitoso',
        token,
        user: userData
      });
      
    } catch (error) {
      console.error('❌ Error en login:', error);
      console.error('📜 Stack trace:', error.stack);
      
      res.status(500).json({
        success: false,
        message: 'Error interno del servidor',
        details: process.env.NODE_ENV === 'development' ? error.message : undefined
      });
    }
  }
);
