/**
 * SCRIPT DE PRUEBA - SISTEMA DUAL-FLOW
 * ====================================================================
 * Este script permite probar las funcionalidades del sistema dual-flow
 * desde la consola del navegador
 */

// Función para simular selección de cliente de prueba
function simularClientePrueba() {
  console.log('🧪 Simulando cliente de prueba...');
  
  // Cliente de prueba
  window.clienteVenta = {
    id: 999,
    nombres: 'Juan Carlos',
    apellidos: 'Pérez González',
    rut: '12.345.678-9',
    telefono: '+56 9 1234 5678',
    email: 'juan.perez@email.com',
    direccion: 'Av. Principal 123',
    comuna: 'Santiago',
    region: 'Metropolitana'
  };
  
  console.log('✅ Cliente simulado:', window.clienteVenta);
}

// Función para simular selección de moto de prueba
function simularMotoPrueba() {
  console.log('🧪 Simulando moto de prueba...');
  
  // Moto de prueba
  window.motoVenta = {
    id: 999,
    id_moto: 999,
    marca: 'Honda',
    modelo: 'CB 600F Hornet',
    año: 2023,
    precio_compra: 3500000,
    kilometraje: 1500,
    estado: 'DISPONIBLE',
    numero_chasis: 'HC600F123456789',
    numero_motor: 'CB600E234567890',
    color: 'Azul Metalizado'
  };
  
  console.log('✅ Moto simulada:', window.motoVenta);
}

// Función para llenar campos de venta
function llenarCamposPrueba() {
  console.log('🧪 Llenando campos de prueba...');
  
  const precioVenta = document.getElementById('precioVenta');
  const descuentoVenta = document.getElementById('descuentoVenta');
  const metodoPago = document.getElementById('metodoPago');
  const observaciones = document.getElementById('observacionesVenta');
  
  if (precioVenta) precioVenta.value = '4200000';
  if (descuentoVenta) descuentoVenta.value = '200000';
  if (metodoPago) metodoPago.value = 'TRANSFERENCIA';
  if (observaciones) observaciones.value = 'Venta de prueba del sistema dual-flow';
  
  console.log('✅ Campos llenados');
}

// Función para probar flujo RESERVAR CON GUARDADO REAL
function probarFlujoReservar() {
  console.log('🎫 === INICIANDO PRUEBA FLUJO RESERVAR (CON GUARDADO REAL) ===');
  
  // Preparar datos
  simularClientePrueba();
  simularMotoPrueba();
  llenarCamposPrueba();
  
  // Simular navegación al paso 3
  if (typeof continuarAPaso === 'function') {
    continuarAPaso(3);
  }
  
  setTimeout(() => {
    // Seleccionar RESERVAR
    if (typeof seleccionarTipoOperacion === 'function') {
      seleccionarTipoOperacion('RESERVAR');
      console.log('✅ Tipo RESERVAR seleccionado');
      
      setTimeout(() => {
        // EJECUTAR FLUJO COMPLETO CON GUARDADO REAL
        if (typeof procesarReserva === 'function') {
          console.log('🚀 Ejecutando flujo de reserva COMPLETO (con guardado)...');
          procesarReserva(); // Esto SÍ guardará el archivo y BD
        } else {
          console.log('❌ Función procesarReserva no encontrada');
        }
      }, 1000);
    } else {
      console.log('❌ Función seleccionarTipoOperacion no encontrada');
    }
  }, 1000);
}

// Función para probar flujo VENTA DIRECTA CON GUARDADO REAL
function probarFlujoVentaDirecta() {
  console.log('🏪 === INICIANDO PRUEBA FLUJO VENTA DIRECTA (CON GUARDADO REAL) ===');
  
  // Preparar datos
  simularClientePrueba();
  simularMotoPrueba();
  llenarCamposPrueba();
  
  // Simular autenticación biométrica
  window.huellaAutenticada = true;
  
  // Simular navegación al paso 3
  if (typeof continuarAPaso === 'function') {
    continuarAPaso(3);
  }
  
  setTimeout(() => {
    // Seleccionar VENTA DIRECTA
    if (typeof seleccionarTipoOperacion === 'function') {
      seleccionarTipoOperacion('VENTA_DIRECTA');
      console.log('✅ Tipo VENTA DIRECTA seleccionado');
      
      setTimeout(() => {
        // EJECUTAR FLUJO COMPLETO CON GUARDADO REAL
        if (typeof procesarVentaDirecta === 'function') {
          console.log('🚀 Ejecutando flujo de venta directa COMPLETO (con guardado)...');
          procesarVentaDirecta(); // Esto SÍ guardará el archivo y BD
        } else {
          console.log('❌ Función procesarVentaDirecta no encontrada');
        }
      }, 1000);
    } else {
      console.log('❌ Función seleccionarTipoOperacion no encontrada');
    }
  }, 1000);
}

// Función para verificar que los archivos se guardaron
async function verificarArchivosGuardados() {
  console.log('📁 === VERIFICANDO ARCHIVOS GUARDADOS ===');
  
  try {
    // Verificar documentos en base de datos
    const response = await fetch('/api/documentos/list');
    if (response.ok) {
      const documentos = await response.json();
      console.log('📄 Documentos en BD:', documentos.data || documentos);
      
      if (documentos.data && documentos.data.length > 0) {
        console.log('✅ Total documentos guardados:', documentos.data.length);
        console.log('📋 Últimos 3 documentos:');
        documentos.data.slice(-3).forEach((doc, index) => {
          console.log(`  ${index + 1}. ${doc.tipo_documento} - ${doc.numero_documento} (${doc.fecha_creacion})`);
        });
      } else {
        console.log('⚠️ No se encontraron documentos guardados');
      }
    } else {
      console.log('❌ Error al consultar documentos:', response.status);
    }
  } catch (error) {
    console.log('❌ Error de conexión:', error.message);
  }
  
  // Verificar endpoint de motos
  try {
    const motosResponse = await fetch('/api/motos');
    if (motosResponse.ok) {
      const motos = await motosResponse.json();
      console.log('🏍️ Motos en sistema:', motos.data ? motos.data.length : 'N/A');
      
      // Buscar motos con estado RESERVADA o VENDIDA (de nuestras pruebas)
      if (motos.data) {
        const motosTest = motos.data.filter(moto => 
          moto.estado === 'RESERVADA' || moto.estado === 'VENDIDA'
        );
        console.log('🎯 Motos afectadas por pruebas:', motosTest.length);
      }
    }
  } catch (error) {
    console.log('❌ Error consultando motos:', error.message);
  }
}

// Función para limpiar datos de prueba
async function limpiarDatosPrueba() {
  console.log('🧹 === LIMPIANDO DATOS DE PRUEBA ===');
  
  const confirmar = confirm('¿Estás seguro de que quieres limpiar los datos de prueba?');
  if (!confirmar) {
    console.log('❌ Limpieza cancelada');
    return;
  }
  
  try {
    // Aquí podrías agregar endpoints para limpiar datos de prueba
    console.log('🧹 Implementar limpieza de datos de prueba...');
    console.log('💡 Por ahora, puedes eliminar manualmente:');
    console.log('   - Archivos en backend/uploads/documentos/');
    console.log('   - Registros de prueba en tabla documentos');
  } catch (error) {
    console.log('❌ Error en limpieza:', error.message);
  }
}

// Función para verificar estado del sistema
function verificarEstadoSistema() {
  console.log('🔍 === VERIFICANDO ESTADO DEL SISTEMA ===');
  
  console.log('Variables globales:');
  console.log('- clienteVenta:', window.clienteVenta || 'No definido');
  console.log('- motoVenta:', window.motoVenta || 'No definido');
  console.log('- tipoOperacion:', window.tipoOperacion || 'No definido');
  console.log('- huellaAutenticada:', window.huellaAutenticada || 'No definido');
  console.log('- pasoActual:', window.pasoActual || 'No definido');
  
  console.log('\nFunciones disponibles:');
  console.log('- seleccionarTipoOperacion:', typeof window.seleccionarTipoOperacion);
  console.log('- validarYContinuar:', typeof window.validarYContinuar);
  console.log('- procesarReserva:', typeof window.procesarReserva);
  console.log('- procesarVentaDirecta:', typeof window.procesarVentaDirecta);
  console.log('- generarNotaVentaReserva:', typeof window.generarNotaVentaReserva);
  console.log('- generarContratoVentaDirecta:', typeof window.generarContratoVentaDirecta);
  
  console.log('\nElementos de UI:');
  console.log('- opcion-reservar:', document.getElementById('opcion-reservar') ? '✅' : '❌');
  console.log('- opcion-venta-directa:', document.getElementById('opcion-venta-directa') ? '✅' : '❌');
  console.log('- alerta-seleccion:', document.getElementById('alerta-seleccion') ? '✅' : '❌');
  console.log('- texto-continuar:', document.getElementById('texto-continuar') ? '✅' : '❌');
  
  // Verificar archivos guardados
  console.log('\n📁 Verificando archivos guardados...');
  verificarArchivosGuardados();
}

// Exportar funciones para uso global
window.testDualFlow = {
  simularClientePrueba,
  simularMotoPrueba,
  llenarCamposPrueba,
  probarFlujoReservar,
  probarFlujoVentaDirecta,
  verificarEstadoSistema,
  verificarArchivosGuardados,
  limpiarDatosPrueba
};

console.log('🧪 Script de prueba cargado. Usar: window.testDualFlow');
console.log('📝 Comandos disponibles:');
console.log('- testDualFlow.verificarEstadoSistema()');
console.log('- testDualFlow.probarFlujoReservar()     // ⚠️ AHORA SÍ GUARDA ARCHIVOS');
console.log('- testDualFlow.probarFlujoVentaDirecta() // ⚠️ AHORA SÍ GUARDA ARCHIVOS');
console.log('- testDualFlow.verificarArchivosGuardados()');
console.log('- testDualFlow.limpiarDatosPrueba()');
console.log('');
console.log('⚠️ IMPORTANTE: Las pruebas ahora SÍ guardan archivos reales en:');
console.log('   📁 backend/uploads/documentos/');
console.log('   🗄️ Tabla documentos en MySQL');
